{if $errors|@count > 0}
    <div class="error">
	<ul>
	    {foreach from=$errors item=error}
		<li>{$error}</li>
	    {/foreach}
	</ul>
    </div>
{/if}

<form action="{$request_uri}" method="post" id="form-config">
    <fieldset {if $acmb_auth_token neq ''}style="display:none"{/if}>
        <div class ="bootstrap">
            <div class="alert alert-info hint">
                <ul>
                    <li>{l s='Puede conseguir su auth token' mod="acumbamail"} <a target="_blank" href="https://acumbamail.com/apidoc/getAuthToken/">{l s='aquí' mod='acumbamail'}</a></li>
                </ul>
            </div>
        </div>
	<legend>{l s='Configuración' mod='acumbamail'}</legend>
	<label>{l s='Auth Token' mod='acumbamail'}</label>
	<div class="margin-form">
	    <input type="text" size="20" name="acmb_auth_token" id="acmb-auth-token-text" value="{$acmb_auth_token}"/>
	</div>
    </fieldset>

{if $acmb_auth_token neq ''}
	<fieldset>
            <legend>{l s='Formularios de suscripción' mod='acumbamail'}</legend>
            {if {$listas|@count} != 0}
                <div class ="bootstrap">
                    <div class="alert alert-info hint">
                        <ul>
                            <li>{l s='Seleccione una lista previamente creada en' mod="acumbamail"}<a target="_blank" href="https://acumbamail.com"/>Acumbamail</a></li>
                            <li>{l s='Se mostrarán los formularios asociados a la lista seleccionada' mod='acumbamail'}</li>
                        </ul>
                    </div>
                </div>
            <label>{l s='Lista' mod='acumbamail'}</label>
	        <div class="margin-form">
		    <select name="list-general" id="list-general-select">
                <option value="">--{l s='Selecciona una Lista' mod='acumbamail'}--</option>
		        {foreach $listas as $lista}
			    <option value="{$lista@key}" {if $selected_list["single"] == $lista@key}selected{/if}>{$lista['name']}</option>
		        {/foreach}
		    </select>
                </div>
                <div class ="bootstrap" id="forms-general-info" {if $selected_list["single"] eq ''}style="display:none"{/if}>
                    <div id="forms-general-forms-hint" class="alert alert-info hint" {if $selected_list["single"] eq ''}style="display:none"{/if}>
                        <ul>
                            <li>{l s='Seleccione un formulario para que aparezca en su tienda de Prestashop' mod='acumbamail'}</li>
                        </ul>
                    </div>
                    <div id="forms-general-forms-alert" class="alert alert-danger" style="display:none">
                        <ul>
                            <li>{l s='La lista seleccionada no tiene ningún formulario asociado' mod='acumbamail'}</li>
                            <li>{l s='Puede crear nuevos formularios' mod='acumbamail'} <a id=forms-general-link target=_blank>{l s='aquí' mod='acumbamail'}</a></li>
                        </ul>
                    </div>
                </div>
                <label id="forms-general-label" {if $selected_list["single"] eq ''}style="display:none"{/if}>{l s='Formularios' mod='acumbamail'}</label>
                <div class="margin-form" id="forms-general-div" {if $selected_list["single"] eq ''}style="display:none"{/if}>
                    <select name="forms-general" id="forms-general-select">
                        <option value="">--{l s='Selecciona un Formulario' mod='acumbamail'}--</option>
                        {foreach $forms as $form}
                            <option value="{$form@key}" {if $selected_form["single"] == $form@key}selected{/if}>{$form['name']}</option>
                        {/foreach}
                    </select>
                </div>
            {else}
                <div class="bootstrap">
                    <div id="forms-general-forms-alert" class="alert alert-danger">
                        <ul>
                            <li>{l s='Su usuario no tiene ninguna lista asociada' mod='acumbamail'}</li>
                            <li>{l s='Puede crear nuevas listas' mod='acumbamail'} <a id=forms-general-link target="_blank" href="https://acumbamail.com/lists/">{l s='aquí' mod='acumbamail'}</a></li>
                        </ul>
                    </div>
                </div>
            {/if}
        </fieldset>
        	<fieldset>
            <legend>{l s='Sincronización de clientes' mod='acumbamail'}</legend>
            {if {$listas|@count} != 0}
                <div class ="bootstrap">
                    <div class="alert alert-info hint">
                        <ul>
                            <li>{l s='Seleccione una lista previamente creada en' mod='acumbamail'} <a target="_blank" href="https://acumbamail.com/">Acumbamail</a></li>
                            <li>{l s='Después de confirmar su compra, los clientes serán añadidos automáticamente a la lista seleccionada' mod='acumbamail'}</li>
                        </ul>
                    </div>
                </div>
            <label>{l s='Lista' mod='acumbamail'}</label>
                <div class="margin-form" id="confirmation-div">
                    <select name="list-subscription">
                <option value="">--{l s='Selecciona una Lista' mod='acumbamail'}--</option>
		        {foreach $listas as $lista}
			    <option value="{$lista@key}" {if $buyers_list["single"] == $lista@key}selected{/if}>{$lista['name']}</option>
		        {/foreach}
		    </select>
                </div>
                <div class ="bootstrap">
                    <div class="alert alert-info hint">
                        <ul>
                            <li>{l s='Al marcar esta casilla los clientes que se suscribieron para recibir la newsletter se añadirán automáticamente a la lista seleccionada' mod='acumbamail'}</li>
                            <li>{l s='Posteriores sincronizaciones deberán ser hechas a través de la configuración de dicho módulo' mod='acumbamail'}</li>
                        </ul>
                    </div>
                </div>
                <label style="margin-left:25px;width: 100%;display: flex;position: absolute;">{l s='Quiero sincronizar a los clientes suscritos a la newsletter de Prestashop' mod='acumbamail'}</label>
                <input type="checkbox" name="sync_newsletter_clients" value="sync" style="position: relative;"/>
            {else}
                <div class="bootstrap">
                    <div id="forms-general-forms-alert" class="alert alert-danger">
                        <ul>
                            <li>{l s='Su usuario no tiene ninguna lista asociada' mod='acumbamail'}</li>
                            <li>{l s='Puede crear nuevas listas' mod='acumbamail'} <a id=forms-general-link target="_blank" href="https://acumbamail.com/lists/">{l s='aquí' mod='acumbamail'}</a></li>
                        </ul>
                    </div>
                </div>
            {/if}
	</fieldset>
{/if}
    <left><input type="submit" id="submit_form" name="submit_form" class="button" value="{l s='Guardar' mod='acumbamail'}"/></left>
    <left><input type="submit" id="reset_form" name="reset_form" class="button" value="{l s='Borrar' mod='acumbamail'}"/></left>
    <input type="hidden" id="sync_in_process" name="sync_in_process" value="{if $sync_in_process}true{else}false{/if}">
</form>

<br/>
<div id="sync-info"></div>
<br/>
<div id="sync-progress-spinner" class="loader" style="display: none;"></div>
<div id="sync-progress-container" style="display:none; margin-top:10px;">
    <div style="background:#eee; width:100%; height:20px; border:1px solid #ccc;">
      <div id="sync-progress-bar" style="height:100%; width:0%; background-color:#4caf50;"></div>
    </div>
</div>
<div id="sync-progress-text" style="margin-top:10px;">
</div>
<div id ="reset_sync_form" style="display:none;">
<form action="{$request_uri}" method="post" id="form-sync-process">
    <left><input type="submit" id="reset_sync_process" name="reset_sync_process" class="button" value="{l s='Parar' mod='acumbamail'}"/></left>
</form>
</div>
<br/>

<script>
    const translations = {ldelim}
        textProcessNotEnd: '{l s="El proceso de sincronización anterior no ha finalizado. Si cree que ha podido existir un error, pulse Parar" mod="acumbamail" js=1}',
        textSelect: '{l s="Selecciona un Formulario" mod="acumbamail" js=1}',
        textInitData : '{l s="Preparando datos..." mod="acumbamail" js=1}',
        textTotal: '{l s="Datos listos. Total clientes a sincronizar" mod="acumbamail" js=1}',
        textInit: '{l s="Iniciando ..." mod="acumbamail" js=1}',
        textProgress: '{l s="Procesados" mod="acumbamail" js=1}',
        textIntotal: '{l s="de" mod="acumbamail" js=1}',
        textEnd: '{l s="Sincronización completa" mod="acumbamail" js=1}'
    {rdelim};
</script>

<style>
    .loader {ldelim}
        border: 6px solid #f3f3f3;
        border-top: 6px solid #3498db;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        animation: spin 1s linear infinite;
        margin: 0 auto;
    {rdelim}

    @keyframes spin {ldelim}
        0% {ldelim} transform: rotate(0deg); {rdelim}
        100% {ldelim} transform: rotate(360deg); {rdelim}
    {rdelim}
</style>


<script>
    $(document).ready(function() {ldelim}
       let btn_submit = document.getElementById('submit_form');
       let btn_reset = document.getElementById('reset_form');
       let reset_sync_form = document.getElementById('reset_sync_form');
       let spinner = document.getElementById('sync-progress-spinner');
       let container = document.getElementById('sync-progress-container');
       let bar = document.getElementById('sync-progress-bar');
       let status = document.getElementById('sync-progress-text');
       let info = document.getElementById('sync-info');
       let sync_in_process = document.getElementById('sync_in_process');
       let totalToSync = 0;
       const LIMIT = 400;

       if (sync_in_process.value === 'true') {ldelim}
           reset_sync_form.style.display = 'block';
           btn_submit.disabled = true;
           btn_reset.disabled = true;
           status.innerText = translations.textProcessNotEnd;
       {rdelim}

        $('#list-general-select').change(function() {ldelim}
            $('#forms-general-select').empty();
            $('#forms-general-select').append($('<option>', {ldelim} value : "" {rdelim}).text("-- " + translations.textSelect + " --"));
            let $list_id = $(this).find("option:selected").attr('value');

            if ($list_id!=='') {ldelim}
                $('#forms-general-info').show();
                let $url = 'https://acumbamail.com/api/1/getForms/';
                let $auth_token = $('#acmb-auth-token-text').val();
                $.post($url, {ldelim}auth_token:$auth_token, list_id:$list_id, response_type:'json'{rdelim}, function(data) {ldelim}
                    if (jQuery.isEmptyObject(data)) {ldelim}
                        $('#forms-general-label').hide();
                        $('#forms-general-div').hide();
                        $('#forms-general-forms-hint').hide();
                        $('#forms-general-link').attr('href', 'https://acumbamail.com/list/'+$list_id+'/form/');
                        $('#forms-general-forms-alert').show();
                   {rdelim}
                    else {ldelim}
                        console.log("Size de data no es cero");
                        $.each(data, function(index, value) {ldelim}
                            $('#forms-general-select').append($('<option>', {ldelim} value : index {rdelim}).text(value.name));
                       {rdelim});
                        $('#forms-general-forms-alert').hide();
                        $('#forms-general-forms-hint').show();
                        $('#forms-general-label').show();
                        $('#forms-general-div').show();
                   {rdelim}
               {rdelim});
           {rdelim}
            else {ldelim}
                $('#forms-general-info').hide();
           {rdelim}
       {rdelim});

       $('#form-config').submit(function(e) {ldelim}

           if ($("[name='sync_newsletter_clients']").prop("checked")) {ldelim}

               btn_submit.disabled = true;
               btn_reset.disabled = true;

               container.style.display = 'none';
               reset_sync_form.style.display = 'none';
               info.innerText = "";
               spinner.style.display = 'block';
               status.innerText = translations.textInitData;

               formData = new FormData(this);
               e.preventDefault();

               fetch(window.location.href + '&ajax=1&action=prepare_sync_list',
                   {ldelim}
                       method: 'POST',
                       body: formData
                   {rdelim}
               )
               .then(
                   res => {ldelim}
                       return res.json();
                   {rdelim}
               )
               .then(data => {ldelim}
                   spinner.style.display = 'none';

                   if (data && data.error) {ldelim}
                       status.innerText = '❌ Error: ' + data.error;
                       btn_submit.disabled = false;
                       btn_reset.disabled = false;
                       return;
                   {rdelim}

                   if (data && data.message) {ldelim}
                       status.innerText = data.message;
                       btn_submit.disabled = false;
                       btn_reset.disabled = false;
                       return;
                   {rdelim}

                   if (data && data.success) {ldelim}
                       document.getElementById('reset_sync_form').style.display = 'block';
                       totalToSync = data.total;
                       info.innerText = translations.textTotal + ": " + totalToSync;
                       container.style.display = 'block';
                       bar.style.width = '0%';
                       bar.style.backgroundColor = '#4caf50';
                       status.innerText = translations.textInit;
                       syncBatch(0, data.client_subscription_list);
                   {rdelim}
               {rdelim});

           {rdelim}
       {rdelim});

       function syncBatch(offset,client_subscription_list) {ldelim}
           fetch(window.location.href + '&ajax=1&action=sync_batch&offset=' + offset + '&list_subscription=' + client_subscription_list)
           .then(res => {ldelim}
                   return res.json();
               {rdelim}
           )
           .then(data => {ldelim}
               if (data && data.error) {ldelim}
                   console.log("ERROR:" + data.error);
                   console.log("DETAIL ERROR:" + data.detail_error);
                   status.innerText = '❌ Error: ' + data.error;
                   bar.style.backgroundColor = 'red';
                   btn_submit.disabled = false;
                   btn_reset.disabled = false;
                   return;
               {rdelim}

               let porcentaje = Math.min(((offset + data.processed) / totalToSync) * 100, 100).toFixed(2);
               bar.style.width = porcentaje + '%';
               status.innerText = translations.textProgress + ": " + (offset + data.processed) + " " + translations.textIntotal +" "+ totalToSync;

               if (data.hasMore) {ldelim}
                   setTimeout(() =>  syncBatch(offset + LIMIT, client_subscription_list), 100);
               {rdelim} else {ldelim}
                   status.innerText = '✅ ' + translations.textEnd + '.';
                   btn_submit.disabled = false;
                   btn_reset.disabled = false;
                   reset_sync_form.style.display= 'none';
               {rdelim}
           {rdelim});
       {rdelim}
   {rdelim});
   </script>
